/*
 * Copyright (c) 2004-2006 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */


/*
 * Abstract:
 *    Declaration of osm_mcm_info_t.
 * This object represents a Multicast Forwarding Information object.
 * This object is part of the OpenSM family of objects.
 *
 * Environment:
 *    Linux User Mode
 *
 * $Revision: 1.5 $
 */

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <opensm/osm_mcm_info.h>

/**********************************************************************
 **********************************************************************/
void
osm_mcm_info_destroy(
  IN osm_mcm_info_t* const p_mcm )
{
  CL_ASSERT( p_mcm );
}

/**********************************************************************
 **********************************************************************/
void
osm_mcm_info_init(
  IN osm_mcm_info_t* const p_mcm,
  IN const ib_net16_t mlid )
{
  CL_ASSERT( p_mcm );
  p_mcm->mlid = mlid;
}

/**********************************************************************
 **********************************************************************/
osm_mcm_info_t*
osm_mcm_info_new(
  IN const ib_net16_t mlid )
{
  osm_mcm_info_t* p_mcm;

  p_mcm = (osm_mcm_info_t*)malloc( sizeof(*p_mcm) );
  if( p_mcm )
  {
    memset(p_mcm, 0, sizeof(*p_mcm) );
    osm_mcm_info_init( p_mcm, mlid );
  }

  return( p_mcm );
}

/**********************************************************************
 **********************************************************************/
void
osm_mcm_info_delete(
  IN osm_mcm_info_t* const p_mcm )
{
  osm_mcm_info_destroy( p_mcm );
  free( p_mcm );
}
